IF EXISTS (select * from sysobjects where name like '%T_Insert_TipoRequisito%')
DROP TRIGGER T_Insert_TipoRequisito
go

CREATE TRIGGER [dbo].[T_Insert_TipoRequisito]
ON  [dbo].[TipoRequisito]
FOR INSERT, UPDATE
AS
	DECLARE @IdTipoRequisito DECIMAL(20,0);
	DECLARE @IdIdioma DECIMAL(20,0);
	DECLARE @Descripcio AS VARCHAR(100);
	DECLARE @Contador DECIMAL(10,0);
		
	DECLARE Elems_Cursor_Insert_TipoRequisito CURSOR FOR
	SELECT IdTipoRequisito,Descripcio FROM INSERTED;
	OPEN Elems_Cursor_Insert_TipoRequisito

	FETCH NEXT FROM Elems_Cursor_Insert_TipoRequisito INTO @IdTipoRequisito,@Descripcio
	WHILE @@FETCH_STATUS = 0
	BEGIN	

		PRINT 'Ejecucion trigger T_Insert_TipoRequisito.'
		/*Cogemos todos los idiomas y creamos los registros de etiquetas de idioma para el estado de operacin*/
		DECLARE Elems_Cursor_Insert_TipoRequisitoAux CURSOR FOR
		SELECT IdIdioma FROM Idioma;
		--SELECT IdIdioma FROM Idioma WHERE PorDefecto=0;
		OPEN Elems_Cursor_Insert_TipoRequisitoAux
		
		FETCH NEXT FROM Elems_Cursor_Insert_TipoRequisitoAux INTO @IdIdioma
		WHILE @@FETCH_STATUS = 0
		BEGIN
		
		/*Miramos que no exista ya el registro*/
		SELECT @Contador = Count(*)
						from EtiquetaIdioma
						where 1=1
						and EtiquetaIdioma.Concepto = 'TIPOREQUISITO'
						and EtiquetaIdioma.Etiqueta = 'TIPOREQUISITO_'+CONVERT(VARCHAR(20),@IdTipoRequisito)
						and EtiquetaIdioma.IdIdioma = @IdIdioma
		
		IF @Contador = 0 
		BEGIN 
			/*Para cada idioma que no es por defecto, creamos la instancia de EtiquetaIdioma*/
			INSERT INTO EtiquetaIdioma (Etiqueta,IdIdioma,Valor,Concepto) VALUES ('TIPOREQUISITO_'+CONVERT(VARCHAR(20),@IdTipoRequisito),@IdIdioma,@Descripcio,'TIPOREQUISITO')
		END
				
		FETCH NEXT FROM Elems_Cursor_Insert_TipoRequisitoAux INTO @IdIdioma
		END
		
		CLOSE Elems_Cursor_Insert_TipoRequisitoAux
		DEALLOCATE Elems_Cursor_Insert_TipoRequisitoAux
		
		/*Para el nuevo estado de operacin actualizamos el valor del campo TagIdioma*/
		UPDATE TipoRequisito SET TagIdioma='TIPOREQUISITO_'+CONVERT(VARCHAR(20),@IdTipoRequisito) WHERE IdTipoRequisito=@IdTipoRequisito
		
	FETCH NEXT FROM Elems_Cursor_Insert_TipoRequisito INTO @IdTipoRequisito,@Descripcio
	END

	CLOSE Elems_Cursor_Insert_TipoRequisito
	DEALLOCATE Elems_Cursor_Insert_TipoRequisito
